<?php

namespace App\Http\Controllers\admin;

use DateTime;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;

class AdminController extends Controller {
    

    public function login() {
        return View('admin.login.login');
    }

    public function doLogin(Request $request) {
        try {
            $validator = \Validator::make($request->all(), [
                        'email' => 'required',
                        'password' => 'required',
            ]);

            if ($validator->fails()) {
                return \redirect()->back()
                                ->withInput()
                                ->withErrors($validator);
            }
            $credentials = [
                'email' => $request->email,
                'password' => $request->password,
            ];
            $admin=\Sentinel::authenticate($credentials);
            if (\Sentinel::authenticate($credentials)) {
                //$admin=\Sentinel::authenticateAndRemember($credentials);
               
                $request->session()->put('admin_name', $admin->first_name.' '.$admin->last_name);
                $request->session()->put('admin_email',$admin->email);
                $request->session()->put('admin_id',$admin->id);
                
                return \Redirect::to('admin/dashboard');
            }
            
//            if (\Sentinel::authenticateAndRemember($credentials)) {
//                //$admin=\Sentinel::authenticateAndRemember($credentials);
//               
//                $request->session()->put('admin_name', $admin->first_name.' '.$admin->last_name);
//                $request->session()->put('admin_email',$admin->email);
//                $request->session()->put('admin_id',$admin->id);
//                
//                return \Redirect::to('admin/dashboard');
//            } 
            //if checkbox remmber me not checked
            /*$credentials = [
                'email' => 'john.doe@example.com',
                'password' => 'password',
            ];

            Sentinel::authenticate($credentials);*/


            //check box remmember me.
            
           
            $errors = 'الايميل او الرقم السرى غير صحيح.';
        } catch (NotActivatedException $e) {
            $errors = 'Account is not activated!';
            return \Redirect::to('/')->with('user', $e->getUser());
        } catch (ThrottlingException $e) {
            $delay = $e->getDelay();
            $errors = "Your account is blocked for {$delay} second(s).";
             return \Redirect::to('/')->with('errors', $errors);
        }catch (\Sentinel\Checkpoints\ThrottlingException $e){
            $error="your ip is blocked please try after some times";
            return \Redirect::to('/')->with('errors', $errors);
        }
        return \Redirect::back()
                        ->withInput()
                        ->withErrors($errors);
    }
    
    public function dologout(Request $request){
        $user = \Sentinel::findUserById(session('admin_id'));

         \Sentinel::logout($user, true);
         $request->session()->forget('admin_name'); 
         $request->session()->forget('admin_email'); 
         $request->session()->forget('admin_id'); 
         $request->session()->forget('admin_lang'); 
         return \Redirect::to('/');
        
    }
    
    public function doLang(Request $request, $lang){
          $request->session()->put('admin_lang',$lang);
                
                return \Redirect::back();
    }
    
    public function fcmToken(Request $request){
         $item = \App\User::find(session('admin_id'));
         $item->ftoken = $request->token;
         $item->save();
         return "updated token";
    }
    
    public static function arabic_date_format_old($timestamp) {
        $months = array("Jan" => "يناير", "Feb" => "فبراير", "Mar" => "مارس", "Apr" => "أبريل", "May" => "مايو", "Jun" => "يونيو", "Jul" => "يوليو", "Aug" => "أغسطس", "Sep" => "سبتمبر", "Oct" => "أكتوبر", "Nov" => "نوفمبر", "Dec" => "ديسمبر");
        $your_date = date('y-m-d',strtotime($timestamp)); // The Current Date
       
        $en_month = date("M", strtotime($your_date));
        foreach ($months as $en => $ar) {
            if ($en == $en_month) {
                $ar_month = $ar;
            }
        }

        $find = array("Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri");
        $replace = array("السبت", "الأحد", "الإثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة");
        $ar_day_format = date('D',strtotime($your_date)); // The Current Day
        $ar_day = str_replace($find, $replace, $ar_day_format);

        header('Content-Type: text/html; charset=utf-8');
        $standard = array("0", "1", "2", "3", "4", "5", "6", "7", "8", "9");
        $eastern_arabic_symbols = array("٠", "١", "٢", "٣", "٤", "٥", "٦", "٧", "٨", "٩");
        $current_date = $ar_day . ' ' . date('d',strtotime($your_date)) . ' / ' . $ar_month . ' / ' . date('Y',strtotime($your_date));
        $arabic_date = str_replace($standard, $eastern_arabic_symbols, $current_date);

        return $arabic_date;
    }
    
    public static function arabic_date_format($timestamp) {

     //   $your_date= date('y-m-d',strtotime($timestamp)); // The Current Date
  	$your_date = DateTime::createFromFormat("d/m/Y", $timestamp);
  	if(!$your_date){
  	$your_date = DateTime::createFromFormat("Y/m/d", $timestamp)  ;
  	 }
  	if($your_date){
  	$your_date = $your_date->format('y-m-d');
  	}else{
        $your_date= date('y-m-d',strtotime($timestamp)); // The Current Date  	
  	}
	$find = array("Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri");
        $replace = array("السبت", "الأحد", "الإثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة");
        $ar_day_format = date('D',strtotime($your_date)); // The Current Day
        $ar_day = str_replace($find, $replace, $ar_day_format);


        $standard = array("0", "1", "2", "3", "4", "5", "6", "7", "8", "9");
        $eastern_arabic_symbols = array("٠", "١", "٢", "٣", "٤", "٥", "٦", "٧", "٨", "٩");
        
        $current_date = date('d',strtotime($your_date)) . ' / ' . date('m',strtotime($your_date)) . ' / ' . date('Y',strtotime($your_date));
        
        $arabic_date = str_replace($standard, $eastern_arabic_symbols, $current_date);

        return $arabic_date;

	}    
    

}
