<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CarController extends Controller {

    public function index() {
            $data['menu_name'] = "cars";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Car::orderBy('created_at', 'desc')->get();
            if(session('admin_lang')== "ar")
                return View('admin.car.indexAr', $data);
            else
                return View('admin.car.indexEn', $data);
        
    }
    
    public function show($id) {
            $data['menu_name'] = "cars";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Car::where('id', $id)->get();
            if(session('admin_lang')== "ar")
                return View('admin.car.indexAr', $data);
            else
                return View('admin.car.indexEn', $data);
        
    }

    public function create() {
            $data['menu_name'] = "cars";
            $data = DashboardController::layout($data);
            return View('admin.car.create', $data);
        
    }

    public function store(Request $request) {
            $rules = [
                'title_en' => 'required',
                'content_en' => 'required',
                'title_ar' => 'required',
                'content_ar' => 'required',
                'color_en' => 'required',
                'color_ar' => 'required',
                'plate' => 'required',
                'from' => 'required',
                'to' => 'required',
                'lat' => 'required',
                'lng' => 'required',
                'price' => 'required',
                'offer' => 'required',

            ];
            $niceNames = [
                
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\Car;

            $item->title_en = $request->title_en;
            $item->content_en = strip_tags($request->content_en);
            $item->title_ar = $request->title_ar;
            $item->content_ar = strip_tags($request->content_ar);
            $item->color_en = $request->color_en;
            $item->color_ar = $request->color_ar;
            $item->plate = $request->plate;
            $item->from = $request->from;
            $item->to = $request->to;
            $item->lat = $request->lat;
            $item->lng = $request->lng;
            $item->price = $request->price;
            $item->offer = $request->offer;

            
            if ($request->hasFile('image')) {
                $destination = base_path('public/admin/images/'); // your upload folder
                $image = $request->file('image');
                $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
                $image->move($destination, $filename); // move file to destination
                $item->image = $filename;
            }
            
           
            $item->save();
            return \Redirect::to('admin/cars/all')->with('message','Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "courses";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Car::find($id);
            return View('admin.car.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
                 'type' => 'required',
            ];
            $niceNames = [
                'title' => 'title ',
                'content' => 'content ',
                'type'  => 'type',
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\Course::find($id);
          

            $item->title = $request->title;
            $item->content = strip_tags($request->content);
            $item->type = $request->type;
            if($request->teacherId){
                $item->teacherId = $request->teacherId; 
            }
            if($request->students){
                $item->students = strip_tags($request->students);
            }

            $item->save();
            return \Redirect::to('admin/courses/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\Car::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }
    
     public static function pushNotification($title,$body,$registrationIds)
     {
         #API access key from Google API's Console
         //  $registrationIds = $tokens;
 
         #prep the bundle
         $data = [
             'title' => $title,
             'body' => $body,
             'type' => 'urgent'
         ];
 
 
         $fields = [
            //  'to' => '/topics/azabAndroid',
            //   'to' => $idtoken,
              'registration_ids'  => $registrationIds,
            //     'notification'      => $data,
             'data' => $data,
             'sound' => 'activated',
             'content_available' => true,
             'priority' => 'high',
         ];

         $headers = [
             'Authorization: key=AAAAaHXcckg:APA91bEojwzLEuOZZI9F7NG2b9G6sSrpS7-kfT7rjuIKBS--obx6ZKh2AH689Dd-kJ5_LhwzdN4wN8ZCA1JHQkCPGkeSemp07-2HD9aO-IHKOtsRl1_Ef4dmH-SncUOE5eRRFDHROc87',
             'Content-Type: application/json'
         ];
 
         // return $fields;
         #Send Response To FireBase Server
         $ch = curl_init();
         curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
         curl_setopt($ch, CURLOPT_POST, true);
         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
         curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
         curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
         $result = curl_exec($ch);
         curl_close($ch);
         #Echo Result Of FireBase Server
         return $result;
 
     }


}
