<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class CareerController extends Controller {

    public function index() {
            $data['menu_name'] = "career";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Career::orderBy('order', 'asc')->orderBy('created_at', 'desc')->get();
            return View('admin.career.index', $data);
    }

    public function create() {
            $data['menu_name'] = "career";
            $data = DashboardController::layout($data);
            return View('admin.career.create', $data);
        
    }

   public function store(Request $request) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
                'order' => 'required',
            ];
            $niceNames = [
                'title' => 'title ',
                'content' => 'content ',
                'order' => 'order',
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\Career;

            $item->title = $request->title;
            $item->content = $request->content;
            $item->order = $request->order;

          
            $item->save();
            return \Redirect::to('admin/careers/all')->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "career";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Career::find($id);
            return View('admin.service.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
                'order' => 'required',
            ];
            $niceNames = [
                'title' => 'title ',
                'content' => 'content ',
                'order' => 'order',
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\Career::find($id);
          
            $item->title = $request->title;
            $item->content = $request->content;
            $item->order = $request->order;

            $item->save();
            return \Redirect::to('admin/careers/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\Career::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }
   
}
