<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class DiplomaController extends Controller {

    public function index() {
            $data['menu_name'] = "diploma";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Diploma::orderBy('updated_at', 'desc')->get();

            return View('admin.diploma.index', $data);
       
    }

    public function create() {
            $data['menu_name'] = "diploma";
            $data = DashboardController::layout($data);
            return View('admin.diploma.create', $data);
      
    }

    public function store(Request $request) {
            $rules = [
                'title' => 'required',     
            ];
            $niceNames = [
                'title' => 'image ',
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\Diploma;

            $item->title = $request->title;
           
            $item->save();
            return \Redirect::to('admin/diploma/all')->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "diploma";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Diploma::find($id);
            return View('admin.diploma.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
            ];
            $niceNames = [
                'title' => 'title ',
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\Diploma::find($id);
        
            $item->title = $request->title;
           
            $item->save();
            return \Redirect::to('admin/diploma/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\Diploma::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }

}
