<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class GalleryController extends Controller {

    public function index($cid) {
            $data['menu_name'] = "gallery";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Gallery::where('car_id',$cid)->get();
            $data['cid'] = $cid;
            return View('admin.gallery.index', $data);
        
    }

    public function create($cid) {
            $data['menu_name'] = "slider";
            $data = DashboardController::layout($data);
                        $data['cid'] = $cid;
            return View('admin.gallery.create', $data);
        
    }

    public function store(Request $request,$cid) {

            $rules = [
                'image' => 'required',
                

            ];
            $niceNames = [
               
                'image' => 'image ',

            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\Gallery;

            $item->car_id = $cid;

            $destination = base_path('public/admin/images/'); // your upload folder
            $image = $request->file('image');
            $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
            $image->move($destination, $filename); // move file to destination
            $item->image = $filename;
            $item->save();
            return \Redirect::to('admin/gallery/'.$cid)->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "slider";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Slider::find($id);
            return View('admin.slider.edit', $data);
    }

    public function update($id, Request $request) {
             $rules = [
                'type' => 'required',
                'time' => 'required',

            ];
            $niceNames = [
                'type' => 'type ',
                'time' => 'time ',

            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\Slider::find($id);
            if ($request->hasFile('file')) {
                $destination = base_path('public/admin/images/slider/'); // your upload folder
                $image = $request->file('file');
                $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
                $image->move($destination, $filename); // move file to destination
                $item->file = $filename;
            }
            $item->title = $request->title?  $request->title: "";
            $item->content = $request->content?  $request->content: "";
            $item->order = $request->order;
            $item->type = $request->type;
            $item->time = $request->time;

            $item->save();
            return \Redirect::to('admin/slider/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\Gallery::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }

}
