<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ISOController extends Controller {

    public function index() {
            $data['menu_name'] = "iso";
            $data = DashboardController::layout($data);
            $data['list'] = \App\ISO::orderBy('updated_at', 'desc')->get();

            return View('admin.iso.index', $data);
       
    }

    public function create() {
            $data['menu_name'] = "iso";
            $data = DashboardController::layout($data);
            return View('admin.iso.create', $data);
      
    }

    public function store(Request $request) {
            $rules = [
                'title' => 'required',
                'file' => 'required',              
            ];
            $niceNames = [
                'title' => 'title ',                
                'file' => 'file ',           
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\ISO;

            $item->title = $request->title;

            $destination = base_path('public/admin/images/iso/'); // your upload folder
            $image = $request->file('file');
            $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
            $image->move($destination, $filename); // move file to destination
            $item->image = $filename;
            $item->save();
            return \Redirect::to('admin/iso/all')->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "iso";
            $data = DashboardController::layout($data);
            $data['item'] = \App\ISO::find($id);
            return View('admin.iso.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
            ];
            $niceNames = [
                'title' => 'title ',
             
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\ISO::find($id);
            if ($request->hasFile('file')) {
                $destination = base_path('public/admin/images/iso/'); // your upload folder
                $image = $request->file('file');
                $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
                $image->move($destination, $filename); // move file to destination
                $item->image = $filename;
            }
            $item->title = $request->title;
           
            $item->save();
            return \Redirect::to('admin/iso/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\ISO::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }

}
