<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Language;

class LanguageController extends Controller {
    
    public function index() {
            $data['menu_name'] = "website_words";
            $data = DashboardController::layout($data);
            $data['list'] = Language::where('editable','1')->get();

            return View('admin.word.index', $data);
        
    }
   

    public function edit($id) {
            $data['menu_name'] = "website_words";
            $data = DashboardController::layout($data);
            $data['item'] = Language::find($id);

            return View('admin.word.edit', $data);
        
    }

    public function update($id, Request $request) {
            $this->validate($request, [
                'nameAr' => 'required',
                // 'nameEn' => 'required',
            ]);
            
            $lang = Language::find($id);
          
            $lang->nameAr = $request->nameAr;
        //     $lang->nameEn = $request->nameEn;
          
            $lang->save();

            return \Redirect::to('admin/words/all')->with('message','Updated Successfully');
        
    }

}
