<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class LicencesController extends Controller {

    public function index() {
            $data['menu_name'] = "licences";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Licences::orderBy('order', 'asc')->orderBy('created_at', 'desc')->get();

            return View('admin.licences.index', $data);
        
    }

    public function create() {
            $data['menu_name'] = "licences";
            $data = DashboardController::layout($data);
            return View('admin.licences.create', $data);
        
    }

  public function store(Request $request) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
                'image' => 'required',
                'type' => 'required',
                'order' => 'required'
            ];
            $niceNames = [
                'title' => 'title ',
                'content' => 'content ',
                'type' => 'type ',
                'image' => 'image ',
                'order' => 'order',
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\Licences;

            $item->title = $request->title;
            $item->content = $request->content;
            $item->type = $request->type;
            $item->order = $request->order;

            $destination = base_path('public/admin/images/licences/'); // your upload folder
            $image = $request->file('image');
            $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
            $image->move($destination, $filename); // move file to destination
            $item->image = $filename;
            $item->save();
            return \Redirect::to('admin/licences/all')->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "licences";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Licences::find($id);
            return View('admin.licences.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
                'type' => 'required',
                'order' =>  'required',
            ];
            $niceNames = [
                'title' => 'title ',
                'content' => 'content ',
                'type' => 'type',
                'order' => 'order',
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\Licences::find($id);
            if ($request->hasFile('image')) {
                $destination = base_path('public/admin/images/licences/'); // your upload folder
                $image = $request->file('image');
                $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
                $image->move($destination, $filename); // move file to destination
                $item->image = $filename;
            }
            $item->type = $request->type;
            $item->title = $request->title;
            $item->content = $request->content;
            $item->order = $request->order;

            $item->save();
            return \Redirect::to('admin/licences/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\Licences::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }


}
