<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class MezaController extends Controller {

    public function index() {
            $data['menu_name'] = "meza";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Meza::orderBy('updated_at', 'desc')->get();

            return View('admin.meza.index', $data);
       
    }

    public function create() {
            $data['menu_name'] = "meza";
            $data = DashboardController::layout($data);
            return View('admin.meza.create', $data);
      
    }

    public function store(Request $request) {
            $rules = [
                'title' => 'required',
            ];
            $niceNames = [
                'title' => 'title',
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\Meza;

            $item->title = $request->title;
            $item->save();
            return \Redirect::to('admin/meza/all')->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "meza";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Meza::find($id);
            return View('admin.meza.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
            ];
            $niceNames = [
                'title' => 'title ',
             
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\Meza::find($id);
            
            $item->title = $request->title;
            
            $item->save();
            return \Redirect::to('admin/meza/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\Meza::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }

}
