<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class NavigationController extends Controller {

    public function index() {
            $data['menu_name'] = "navigation";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Navigation::orderBy('order', 'asc')->orderBy('created_at', 'desc')->get();
            return View('admin.navigation.index', $data);
    }

    public function create() {
            $data['menu_name'] = "navigation";
            $data = DashboardController::layout($data);
            return View('admin.navigation.create', $data);
    }

   public function store(Request $request) {
            $rules = [
                'title' => 'required',
                'link' => 'required',
                'type' => 'required',
                'order' => 'required',

            ];
            $niceNames = [
                'title' => 'title ',
                'link' => 'link',
                'type' => 'type',
                'order' => 'order',

            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\Navigation;

            $item->title = $request->title;
            $item->link = $request->link;
            $item->type = $request->type;
            $item->order = $request->order;

            $item->save();
            return \Redirect::to('admin/navigation/all')->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "navigation";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Navigation::find($id);
            return View('admin.navigation.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
                'link' => 'required',
                'type' => 'required',
                'order' => 'required',

            ];
            $niceNames = [
                'title' => 'title ',
                'link' => 'link ',
                'type' => 'type',
                'order' => 'order',

            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\Navigation::find($id);
            $item->title = $request->title;
            $item->link = $request->link;
            $item->type = $request->type;
            $item->order = $request->order;
            
            $item->save();
            return \Redirect::to('admin/navigation/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\Navigation::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }

}