<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class SliderController extends Controller {

    public function index() {
            $data['menu_name'] = "slider";
            $data = DashboardController::layout($data);
            $data['list'] = \App\Slider::orderBy('updated_at', 'desc')->get();

            return View('admin.slider.index', $data);
       
    }

    public function create() {
            $data['menu_name'] = "slider";
            $data = DashboardController::layout($data);
            return View('admin.slider.create', $data);
      
    }

    public function store(Request $request) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
                'file' => 'required',
                'order' => 'required',              
            ];
            $niceNames = [
                'title' => 'image ',
                'content' => 'image ',
                'order' => 'order ',
                'file' => 'file ',
              
            ];
            $this->validate($request, $rules, [], $niceNames);

            $item = new \App\Slider;

            $item->title = $request->title;
            $item->content = $request->content;
            $item->order = $request->order;
            $item->type = 1;//$request->type;

            $destination = base_path('public/admin/images/slider/'); // your upload folder
            $image = $request->file('file');
            $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
            $image->move($destination, $filename); // move file to destination
            $item->image = $filename;
            $item->save();
            return \Redirect::to('admin/slider/all')->with('message', 'Added Successfully');
      
    }

    public function edit($id) {
            $data['menu_name'] = "slider";
            $data = DashboardController::layout($data);
            $data['item'] = \App\Slider::find($id);
            return View('admin.slider.edit', $data);
    }

    public function update($id, Request $request) {
            $rules = [
                'title' => 'required',
                'content' => 'required',
            ];
            $niceNames = [
                'title' => 'title ',
                'content' => 'content ',
             
            ];
            $this->validate($request, $rules, [], $niceNames);
            
            $item = \App\Slider::find($id);
            if ($request->hasFile('file')) {
                $destination = base_path('public/admin/images/slider/'); // your upload folder
                $image = $request->file('file');
                $filename = time() . '_' . str_random(10) . '.' . $image->getClientOriginalExtension(); // get the filename
                $image->move($destination, $filename); // move file to destination
                $item->image = $filename;
            }
            $item->title = $request->title;
            $item->content = $request->content;
            $item->order = $request->order;
            // $item->type = $request->type;
            
            $item->save();
            return \Redirect::to('admin/slider/all')->with('message', 'Updated Successfully');
      
    }

    public function delete($id) {
            $category = \App\Slider::find($id);
            $category->delete();
            return \Redirect::back()->with('message', 'Deleted Successfully');
    }

}
