<?php

namespace App\Http\Controllers\theme;

use App\Http\Controllers\Controller;
use Carbon\Carbon;
use Illuminate\Http\Request;


class CarController extends Controller
{

    public function carInfo($id)
    {
        $data = CarController::layout();
        
        $data['item'] = \App\Car::with('gallery')->find($id);
        
        return view('theme/carsingle')->with($data);
    }

    public function index()
    {
        $data = CarController::layout();
        $data['list'] = \App\Car::all();
        return view('theme/cars')->with($data);
    }
    
     public function carResult(Request $request)
    {
        $data = CarController::layout();
        $data['list'] = \App\Car::whereDate('from','<=',$request->from)->where('to','>=',$request->to)->get();
        return view('theme/cars')->with($data);
    }
    
    public function SendRequest(Request $request){
           $data= CarController::layout();

        $rules = [
                'name' => 'required',
                'email' => 'required',
                'phone' => 'required',
                'days' => 'required',
                'from' => 'required',
                'to' => 'required',
                'fplace' => 'required',
                'tplace' => 'required',
                'car_id' => 'required',

            ];
            $niceNames = [
                'name' => 'name',
                'email' => 'email',
                'phone' => 'phone',
                'days' => 'Days',
                'from' => 'from',
                'to' => 'to',
                'fplace' => 'fplace',
                'tplace' => 'tplace',
            ];
        $this->validate($request, $rules, [], $niceNames);

        $item = new \App\Order;
        
        $item->car_id = $request->car_id;
         $car = \App\Car::find($request->car_id);
        if(session('site_lang') == "ar"){
             $item->title = $car->title_ar;
             $item->plate = $car->plate;
             
        }else{
             $item->title = $car->title_en;
             $item->plate = $car->plate;
        }
        
        
        $date1 = strtotime($request->from);
        $date2 = strtotime($request->to);
        $diff = $date2 - $date1;
        $days = floor($diff / (60 * 60 * 24));
        
        if($days !=$request->days ){
          //    return \Redirect::back()->with('error', 'Number of Days you enter is wrong');
        }
        
        $item->name = $request->name;
        $item->email = $request->email;
        $item->phone = $request->phone;
        $item->days = $request->days;
        $item->from = $request->from;
        $item->to = $request->to;
        $item->fplace = $request->fplace;
        $item->tplace = $request->tplace;
        $item->status = 0;
        $item->price = ($car->price  - (($car->price * $car->offer) / 100) ) * $days; 
        if($request->web){
              $item->type = "WebSite";
              if($request->session()->get('user_id')){
                  $item->user_id = $request->session()->get('user_id');
              }
              $item->save();
              return \Redirect::to('/')->with('message', $data['language']['site_word_request_sent_successfully']);
        }else if($request->whats){
              $item->type ="WhatsApp";
              $item->save();
              
              $data['whatsapp'] =  $data['language']['site_word_request_sent_successfully_redirect_whatsapp'];
              $data['car_id'] = $request->car_id;
              $data['link'] = $data['language']['site_word_i_want_book_car']
              .'%0A'. url('/car/'.$request->car_id) . '%0A'
              .$data['language']['name'] .' : '.$request->name .'%0A'
              .$data['language']['site_word_email'] .' : '.$request->email .'%0A'
              .$data['language']['site_word_phone'] .' : '.$request->phone .'%0A'
              .$data['language']['site_word_num_days'] .' : '.$request->days .'%0A'
              .$data['language']['site_word_pick_up_date'] .' : '.$request->from .'%0A'
              .$data['language']['site_word_drop_off_date'] .' : '.$request->to .'%0A'
              .$data['language']['site_word_pick_up_address'] .' : '.$request->fplace .'%0A'
              .$data['language']['site_word_drop_off_address'] .' : '.$request->tplace .'%0A';
              return \Redirect::to('/')->with($data);
              
        }else{
              $item->type ="unknown";
              $item->save();
              return \Redirect::to('/')->with('message', $data['language']['site_word_request_sent_successfully']);
            
        }
        
    }


    public static function layout()
    {
        $data['site_setting'] = \App\Setting::find(1);
         $language = \App\Language::all();
        
        $result = array();
          foreach ($language as $lang)
          { 
            $key = $lang['key'];
            if(session('site_lang') == "ar"){
                $lang->name = $lang->nameAr;
            }else{
                $lang->name = $lang->nameEn;
            }  
            $result[$key] = $lang->name;
          }
       
        $data['language'] =   $result ; 
        return $data;
    }
}
