<?php

/*
  |--------------------------------------------------------------------------
  | Application Routes
  |--------------------------------------------------------------------------
  |
  | Here is where you can register all of the routes for an application.
  | It's a breeze. Simply tell Laravel the URIs it should respond to
  | and give it the controller to call when that URI is requested.
  |
 */


//Route::get('/', function () {
//    /* $credentials = [
//      'email' => 'ahmedzidan_2015@hotmail.com',
//      'password' => '20110093',
//      'first_name'=>'ahmed',
//      'last_name'=>'zidan',
//      ];
//
//      $user = Sentinel::registerAndActivate($credentials);
//      print_r($user); */
//	  echo 'here';
//});

//Route::get('/', 'admin\AdminController@login');
Route::get('/', 'theme\HomeController@index');
Route::get('/home', 'theme\HomeController@index');
Route::get('/studies', 'theme\HomeController@studies');
Route::get('/consultation', 'theme\HomeController@consultation');
Route::get('/training', 'theme\HomeController@training');
Route::get('/contact', 'theme\HomeController@contact');
Route::get('/recruitment', 'theme\HomeController@recruitment');
Route::get('/certification', 'theme\HomeController@certification');
Route::get('/jobs', 'theme\HomeController@jobs');
Route::get('/mba', 'theme\HomeController@mba');
Route::get('/diploma', 'theme\HomeController@diploma');
Route::get('/clients', 'theme\HomeController@clients');
Route::get('/meza', 'theme\HomeController@meza');
Route::get('/policy', 'theme\HomeController@policy');
Route::get('/contact/send', 'theme\HomeController@sendContact');
Route::get('/about', 'theme\HomeController@about');
Route::get('/profile', 'theme\HomeController@profile');
Route::get('/lang/{lang}','theme\HomeController@doLang');
Route::get('/car/{cid}','theme\CarController@carInfo');
Route::get('/cars','theme\CarController@index');
Route::get('/cars/result','theme\CarController@carResult');
Route::Post('/request/send','theme\CarController@SendRequest');
Route::Post('/signin', 'theme\HomeController@signin');
Route::Post('/signup', 'theme\HomeController@signup');


 Route::get('dashboard/', 'admin\AdminController@login');


Route::get('admin/login', array('as' => 'adminLogin', 'uses' => 'admin\AdminController@login'));
Route::post('admin/login', array('as' => 'adminLoginvalidation', 'uses' => 'admin\AdminController@doLogin'));
Route::group(['middleware' => 'auth', 'prefix' => 'admin'], function () {
    Route::get('dashboard', array('as' => 'Dashboard', 'uses' => 'admin\DashboardController@index'));
    Route::get('logout', array('as' => 'adminLogout', 'uses' => 'admin\AdminController@doLogout'));
    Route::patch('fcm-token', array('uses' => 'admin\AdminController@fcmToken'))->name('fcmToken');
    Route::get('lang/{lang}', array('as' => 'adminLang', 'uses' => 'admin\AdminController@doLang'));

    /*
     * roles routes
     */
    Route::get('group/all', array('uses' => 'admin\GroupController@index'));
    Route::get('group/create', array('uses' => 'admin\GroupController@create'));
    Route::post('group/store', array('uses' => 'admin\GroupController@store'));
    Route::get('group/edit/{id}', array('uses' => 'admin\GroupController@edit'));
    Route::post('group/update/{id}', array('uses' => 'admin\GroupController@update'));
    Route::get('group/delete/{id}', array('uses' => 'admin\GroupController@delete'));
    /*
     * users routes
     */
    Route::get('user/all', array('uses' => 'admin\UserController@index'));
    Route::get('user/create', array('uses' => 'admin\UserController@create'));
    Route::post('user/store', array('uses' => 'admin\UserController@store'));
    Route::get('user/edit/{id}', array('uses' => 'admin\UserController@edit'));
    Route::post('user/update/{id}', array('uses' => 'admin\UserController@update'));
    Route::get('user/delete/{id}', array('uses' => 'admin\UserController@delete'));
    Route::get('user/profile', array('uses' => 'admin\UserController@profile'));
    Route::post('user/update/profile/{id}', array('uses' => 'admin\UserController@updateProfile'));
    /*
     * setting routes
     */

    Route::get('setting/edit', array('uses' => 'admin\SettingController@edit'));
    Route::post('setting/update/{id}', array('uses' => 'admin\SettingController@update'));
    /*
     * language routes
     */

    Route::get('words/all', array('uses' => 'admin\LanguageController@index'));
    Route::get('words/edit/{id}', array('uses' => 'admin\LanguageController@edit'));
    Route::post('words/update/{id}', array('uses' => 'admin\LanguageController@update'));

    /*
     * clients routes
     */
    Route::get('clients/all', array('uses' => 'admin\ClientController@index'));
    Route::get('clients/create', array('uses' => 'admin\ClientController@create'));
    Route::post('clients/store', array('uses' => 'admin\ClientController@store'));
    Route::get('clients/edit/{id}', array('uses' => 'admin\ClientController@edit'));
    Route::post('clients/update/{id}', array('uses' => 'admin\ClientController@update'));
    Route::get('clients/delete/{id}', array('uses' => 'admin\ClientController@delete'));
    Route::get('clients/show/{id}', array('uses' => 'admin\ClientController@show'));

    /*
     * slider routes
     */
    Route::get('slider/all', array('uses' => 'admin\SliderController@index'));
    Route::get('slider/create', array('uses' => 'admin\SliderController@create'));
    Route::post('slider/store', array('uses' => 'admin\SliderController@store'));
    Route::get('slider/edit/{id}', array('uses' => 'admin\SliderController@edit'));
    Route::post('slider/update/{id}', array('uses' => 'admin\SliderController@update'));
    Route::get('slider/delete/{id}', array('uses' => 'admin\SliderController@delete'));
   
     /*
     * meza routes
     */
    Route::get('meza/all', array('uses' => 'admin\MezaController@index'));
    Route::get('meza/create', array('uses' => 'admin\MezaController@create'));
    Route::post('meza/store', array('uses' => 'admin\MezaController@store'));
    Route::get('meza/edit/{id}', array('uses' => 'admin\MezaController@edit'));
    Route::post('meza/update/{id}', array('uses' => 'admin\MezaController@update'));
    Route::get('meza/delete/{id}', array('uses' => 'admin\MezaController@delete'));
   
      /*
     * mba routes
     */
    Route::get('mba/all', array('uses' => 'admin\MBAController@index'));
    Route::get('mba/create', array('uses' => 'admin\MBAController@create'));
    Route::post('mba/store', array('uses' => 'admin\MBAController@store'));
    Route::get('mba/edit/{id}', array('uses' => 'admin\MBAController@edit'));
    Route::post('mba/update/{id}', array('uses' => 'admin\MBAController@update'));
    Route::get('mba/delete/{id}', array('uses' => 'admin\MBAController@delete'));
   
      /*
     * diploma routes
     */
    Route::get('diploma/all', array('uses' => 'admin\DiplomaController@index'));
    Route::get('diploma/create', array('uses' => 'admin\DiplomaController@create'));
    Route::post('diploma/store', array('uses' => 'admin\DiplomaController@store'));
    Route::get('diploma/edit/{id}', array('uses' => 'admin\DiplomaController@edit'));
    Route::post('diploma/update/{id}', array('uses' => 'admin\DiplomaController@update'));
    Route::get('diploma/delete/{id}', array('uses' => 'admin\DiplomaController@delete'));
   
      /*
     * cert routes
     */
    Route::get('cert/all', array('uses' => 'admin\CertificationController@index'));
    Route::get('cert/create', array('uses' => 'admin\CertificationController@create'));
    Route::post('cert/store', array('uses' => 'admin\CertificationController@store'));
    Route::get('cert/edit/{id}', array('uses' => 'admin\CertificationController@edit'));
    Route::post('cert/update/{id}', array('uses' => 'admin\CertificationController@update'));
    Route::get('cert/delete/{id}', array('uses' => 'admin\CertificationController@delete'));
   
      /*
     * team routes
     */
    Route::get('team/all', array('uses' => 'admin\TeamController@index'));
    Route::get('team/create', array('uses' => 'admin\TeamController@create'));
    Route::post('team/store', array('uses' => 'admin\TeamController@store'));
    Route::get('team/edit/{id}', array('uses' => 'admin\TeamController@edit'));
    Route::post('team/update/{id}', array('uses' => 'admin\TeamController@update'));
    Route::get('team/delete/{id}', array('uses' => 'admin\TeamController@delete'));
   
      /*
     * review routes
     */
    Route::get('review/all', array('uses' => 'admin\ReviewController@index'));
    Route::get('review/create', array('uses' => 'admin\ReviewController@create'));
    Route::post('review/store', array('uses' => 'admin\ReviewController@store'));
    Route::get('review/edit/{id}', array('uses' => 'admin\ReviewController@edit'));
    Route::post('review/update/{id}', array('uses' => 'admin\ReviewController@update'));
    Route::get('review/delete/{id}', array('uses' => 'admin\ReviewController@delete'));
   
      /*
     * iso routes
     */
    Route::get('iso/all', array('uses' => 'admin\ISOController@index'));
    Route::get('iso/create', array('uses' => 'admin\ISOController@create'));
    Route::post('iso/store', array('uses' => 'admin\ISOController@store'));
    Route::get('iso/edit/{id}', array('uses' => 'admin\ISOController@edit'));
    Route::post('iso/update/{id}', array('uses' => 'admin\ISOController@update'));
    Route::get('iso/delete/{id}', array('uses' => 'admin\ISOController@delete'));
   
     /*
     * jobs routes
     */
    Route::get('jobs/all', array('uses' => 'admin\JobsController@index'));
    Route::get('jobs/create', array('uses' => 'admin\JobsController@create'));
    Route::post('jobs/store', array('uses' => 'admin\JobsController@store'));
    Route::get('jobs/edit/{id}', array('uses' => 'admin\JobsController@edit'));
    Route::post('jobs/update/{id}', array('uses' => 'admin\JobsController@update'));
    Route::get('jobs/delete/{id}', array('uses' => 'admin\JobsController@delete'));
   
    /*
     * cuttingway routes
     */
    Route::get('gallery/{cid}', array('uses' => 'admin\GalleryController@index'));
    Route::get('gallery/{cid}/create', array('uses' => 'admin\GalleryController@create'));
    Route::post('gallery/{cid}/store', array('uses' => 'admin\GalleryController@store'));
    // Route::get('gallery/edit/{id}', array('uses' => 'admin\GalleryController@edit'));
    // Route::post('gallery/update/{id}', array('uses' => 'admin\GalleryController@update'));
    Route::get('gallery/delete/{id}', array('uses' => 'admin\GalleryController@delete'));
    /*
     * services routes
     */
    Route::get('orders/all', array('uses' => 'admin\OrderController@index'));
    Route::get('orders/create', array('uses' => 'admin\OrderController@create'));
    Route::post('orders/store', array('uses' => 'admin\OrderController@store'));
    Route::get('orders/edit/{id}', array('uses' => 'admin\OrderController@edit'));
    Route::post('orders/update/{id}', array('uses' => 'admin\OrderController@update'));
    Route::get('orders/delete/{id}', array('uses' => 'admin\OrderController@delete'));
      /*
     * sub services routes
     */
    Route::get('services/sub/{sid}', array('uses' => 'admin\SubServiceController@index'));
    Route::get('services/sub/{sid}/create', array('uses' => 'admin\SubServiceController@create'));
    Route::post('services/sub/{sid}/store', array('uses' => 'admin\SubServiceController@store'));
    Route::get('services/sub/edit/{id}', array('uses' => 'admin\SubServiceController@edit'));
    Route::post('services/sub/update/{id}', array('uses' => 'admin\SubServiceController@update'));
    Route::get('services/sub/delete/{id}', array('uses' => 'admin\SubServiceController@delete'));
     /*
     * hashoway routes
     */
    Route::get('licences/all', array('uses' => 'admin\LicencesController@index'));
    Route::get('licences/create', array('uses' => 'admin\LicencesController@create'));
    Route::post('licences/store', array('uses' => 'admin\LicencesController@store'));
    Route::get('licences/edit/{id}', array('uses' => 'admin\LicencesController@edit'));
    Route::post('licences/update/{id}', array('uses' => 'admin\LicencesController@update'));
    Route::get('licences/delete/{id}', array('uses' => 'admin\LicencesController@delete'));
    /*
     * khaltaway routes
     */
    Route::get('news/all', array('uses' => 'admin\NewsController@index'));
    Route::get('news/create', array('uses' => 'admin\NewsController@create'));
    Route::post('news/store', array('uses' => 'admin\NewsController@store'));
    Route::get('news/edit/{id}', array('uses' => 'admin\NewsController@edit'));
    Route::post('news/update/{id}', array('uses' => 'admin\NewsController@update'));
    Route::get('news/delete/{id}', array('uses' => 'admin\NewsController@delete'));
     /*
     * khaltaway routes
     */
    Route::get('slider/all', array('uses' => 'admin\SliderController@index'));
    Route::get('slider/create', array('uses' => 'admin\SliderController@create'));
    Route::post('slider/store', array('uses' => 'admin\SliderController@store'));
    Route::get('slider/edit/{id}', array('uses' => 'admin\SliderController@edit'));
    Route::post('slider/update/{id}', array('uses' => 'admin\SliderController@update'));
    Route::get('slider/delete/{id}', array('uses' => 'admin\SliderController@delete'));

    /*
     * delivery time routes
     */
    Route::get('about/all', array('uses' => 'admin\AboutController@index'));
    Route::get('about/create', array('uses' => 'admin\AboutController@create'));
    Route::post('about/store', array('uses' => 'admin\AboutController@store'));
    Route::get('about/edit/{id}', array('uses' => 'admin\AboutController@edit'));
    Route::post('about/update/{id}', array('uses' => 'admin\AboutController@update'));
    Route::get('about/delete/{id}', array('uses' => 'admin\AboutController@delete'));
   /*
     * challenge routes
     */
    Route::get('challenge/all', array('uses' => 'admin\ChallengeController@index'));
    Route::get('challenge/create', array('uses' => 'admin\ChallengeController@create'));
    Route::post('challenge/store', array('uses' => 'admin\ChallengeController@store'));
    Route::get('challenge/edit/{id}', array('uses' => 'admin\ChallengeController@edit'));
    Route::post('challenge/update/{id}', array('uses' => 'admin\ChallengeController@update'));
    Route::get('challenge/delete/{id}', array('uses' => 'admin\ChallengeController@delete'));

     /*
     * NavigationController routes
     */
    Route::get('navigation/all', array('uses' => 'admin\NavigationController@index'));
    Route::get('navigation/create', array('uses' => 'admin\NavigationController@create'));
    Route::post('navigation/store', array('uses' => 'admin\NavigationController@store'));
    Route::get('navigation/edit/{id}', array('uses' => 'admin\NavigationController@edit'));
    Route::post('navigation/update/{id}', array('uses' => 'admin\NavigationController@update'));
    Route::get('navigation/delete/{id}', array('uses' => 'admin\NavigationController@delete'));

  
   
    /*
     * maincategory routes
     */
    Route::get('contact/all', array('uses' => 'admin\ContactController@index'));
    Route::get('contact/edit/{id}', array('uses' => 'admin\ContactController@edit'));
    Route::post('contact/update/{id}', array('uses' => 'admin\ContactController@update'));
    Route::get('contact/delete/{id}', array('uses' => 'admin\ContactController@delete'));
   
    
   
});


Route::get('/', 'theme\HomeController@index');

// helper

  //Clear route cache:
     Route::get('/route-cache', function() {
        $exitCode = Artisan::call('route:clear');
         return 'Routes cache cleared';
     });

     //Clear config cache:
     Route::get('/config-cache', function() {
         $exitCode = Artisan::call('config:cache');
         return 'Config cache cleared';
     }); 
    
    // Clear application cache:
     Route::get('/clear-cache', function() {
         $exitCode = Artisan::call('cache:clear');
         return 'Application cache cleared';
     });
    
     // Clear view cache:
     Route::get('/view-clear', function() {
         $exitCode = Artisan::call('view:clear');
         return 'View cache cleared';
     }); 

// api
 
 Route::group(['prefix' => 'api'], function () {
    Route::get('/', 'ApiController@index');
    Route::post('login', 'ApiController@login');
    Route::post('register', 'ApiController@register');
    Route::get('courses', 'ApiController@getCourses');
    Route::get('info', 'ApiController@getInfo');
    Route::get('message/student', 'ApiController@getStudentMessage');
    Route::get('message/teacher', 'ApiController@getTeacherMessage');
    Route::post('message/send', 'ApiController@sendMessage');
    Route::post('message/reply', 'ApiController@replyMessage');
    Route::post('message/delete', 'ApiController@deleteMessage');
    Route::get('teacher/home', 'ApiController@getTeacherHome');
    Route::post('course/join', 'ApiController@joinCourse');
    Route::post('course/accept', 'ApiController@acceptCourse');
    Route::get('profile', 'ApiController@getProfile');
    Route::post('profile/update', 'ApiController@updateProfile');
    Route::post('ftoken/update', 'ApiController@updateFirebaseToken');
    Route::get('student/courses', 'ApiController@getStudentCourses');
    Route::get('teacher/courses', 'ApiController@getTeacherCourses');
    Route::post('teacher/course/delete', 'ApiController@deleteTeacherCourse');
    Route::post('teacher/course/add', 'ApiController@addTeacherCourse');
    Route::get('student/list', 'ApiController@getStudentList');
    Route::post('student/course/delete', 'ApiController@deleteStudentCourse');
    Route::get('teacher/time/list', 'ApiController@getTeacherTime');
    Route::post('teacher/time/delete', 'ApiController@deleteTeacherTime');
    Route::post('teacher/lesson/add', 'ApiController@addTeacherLesson');
    Route::post('teacher/time/add', 'ApiController@addTeacherTime');
    Route::get('teacher/lesson/list', 'ApiController@getTeacherLesson');
    Route::post('teacher/lesson/delete', 'ApiController@deleteTeacherLesson');

    Route::get('action/all', 'ApiController@getAllActions');
    Route::get('affiliation/all', 'ApiController@getAllAffiliations');
    Route::get('article/all', 'ApiController@getAllArticles');
    Route::get('book/all', 'ApiController@getAllBooks');
    Route::get('highlight/all', 'ApiController@getAllHighights');
    Route::get('image/all', 'ApiController@getAllImages');
    Route::get('membership/all', 'ApiController@getAllMemberships');
    Route::get('news/all', 'ApiController@getAllNews');
    Route::get('research/all', 'ApiController@getAllResearches');
    Route::get('resume/all', 'ApiController@getAllResumes');
    Route::get('slider/all', 'ApiController@getAllSliders');
    Route::get('testimonial/all', 'ApiController@getAllTestimonials');
    Route::post('zaglol', 'ApiController@zaglol');

    Route::get('version', 'ApiController@getVersion');
});
 


 

 