<!DOCTYPE html>
<html lang="en">

<head>
<meta charset="utf-8">
    <title><?php echo e($language['site_title']); ?></title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@500;600;700&family=Open+Sans:wght@400;500&display=swap" rel="stylesheet">  

    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="public/theme/lib/animate/animate.min.css" rel="stylesheet">
    <link href="public/theme/lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">
 <?php if(session('site_lang') == "ar"): ?>
    <!-- Customized Bootstrap Stylesheet -->
    <link href="public/theme/css/bootstrap_ar.min.css" rel="stylesheet">
    <!-- Template Stylesheet -->
    <link href="public/theme/css/style_ar.css" rel="stylesheet">
<?php else: ?>
    <!-- Customized Bootstrap Stylesheet -->
    <link href="public/theme/css/bootstrap_en.min.css" rel="stylesheet">
    <!-- Template Stylesheet -->
    <link href="public/theme/css/style_en.css" rel="stylesheet">
<?php endif; ?>
</head>

<body>
    <!-- Spinner Start -->
    <div id="spinner" class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
        <div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;"></div>
    </div>
    <!-- Spinner End -->


    <!-- Navbar Start -->
    <div class="container-fluid fixed-top px-0 wow fadeIn" data-wow-delay="0.1s">
        

        <nav class="navbar navbar-expand-lg navbar-light py-lg-0 px-lg-5 wow fadeIn" data-wow-delay="0.1s">
            <a href="index.html" class="navbar-brand ms-4 ms-lg-0">
                <h1 class="display-5 text-primary m-0">Finanza</h1>
            </a>
            <button type="button" class="navbar-toggler me-4" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarCollapse">
                <div class="navbar-nav ms-auto p-4 p-lg-0">
                    <a href="/" class="nav-item nav-link"><?php echo e($language['site_word_home']); ?></a>
                    <a href="page" class="nav-item nav-link active"><?php echo e($language['site_word_about_us']); ?></a>
                    <a href="#" class="nav-item nav-link"><?php echo e($language['site_word_training']); ?></a>
                    <a href="#" class="nav-item nav-link"><?php echo e($language['site_word_consultation']); ?></a>
                    <a href="#" class="nav-item nav-link"><?php echo e($language['site_word_feasibility_studies']); ?></a>
                    <a href="#" class="nav-item nav-link"><?php echo e($language['site_word_recruitment']); ?></a>
                </div>
                <div class="d-none d-lg-flex ms-2">
                    <a class="btn btn-light btn-sm-square rounded-circle ms-3" href="<?php echo e($site_setting->facebook); ?>">
                        <small class="fab fa-facebook-f text-primary" style="color: #f9b21c !important;"></small>
                    </a>
                    <a class="btn btn-light btn-sm-square rounded-circle ms-3" href="<?php echo e($site_setting->twitter); ?>">
                        <small class="fab fa-twitter text-primary" style="color: #f9b21c !important;"></small>
                    </a>
                    <a class="btn btn-light btn-sm-square rounded-circle ms-3" href="<?php echo e($site_setting->linkedin); ?>">
                        <small class="fab fa-linkedin-in text-primary" style="color: #f9b21c !important;"></small>
                    </a>
                </div>
            </div>
        </nav>
    </div>
    <!-- Navbar End -->


    <!-- Page Header Start -->
    <div class="container-fluid page-header mb-5 wow fadeIn" data-wow-delay="0.1s">
        <div class="container">
            <h1 class="display-3 mb-4 animated slideInDown">About</h1>
            <nav aria-label="breadcrumb animated slideInDown">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Pages</a></li>
                    <li class="breadcrumb-item active" aria-current="page">About</li>
                </ol>
            </nav>
        </div>
    </div>
    <!-- Page Header End -->


    <!-- About Start -->
    <div class="container-xxl py-5">
        <div class="container">
            <div class="row g-4 h-100 justify-content-center align-items-center mb-4">
               
                <div class="col-lg-8 wow fadeInUp" data-wow-delay="0.3s">
                    <!-- <p class="d-inline-block border rounded text-primary fw-semi-bold py-1 px-3">About Us</p> -->
                    <!-- <h1 class="display-5 mb-4"> -->
                        <?php echo $language['site_word_training_section_1']; ?>

                    <!-- </h1> -->
                    <p class="mb-4"></p>
                </div>
                <div class="col-lg-4  wow fadeInUp" data-wow-delay="0.1s">
                    <img class="img-fluid rounded" src="public/theme/img/about.jpg">
                </div>
            </div>
        </div>
    </div>
    <!-- About End -->
    <!-- About Start -->
    <div class="container-xxl py-5">
            <div class="container">
                <div class="row g-4 align-items-center mb-4">
                    <div class="col-lg-5 wow fadeInUp" data-wow-delay="0.1s">
                        <img class="img-fluid rounded" src="public/theme/img/about.jpg">
                    </div>
                    <div class="col-lg-7 wow fadeInUp" data-wow-delay="0.3s">
                        <!-- <p class="d-inline-block border rounded text-primary fw-semi-bold py-1 px-3">About Us</p> -->
                        <!-- <h1 class="display-5 mb-4"> -->
                            <?php echo $language['site_word_training_section_2']; ?>

                        <!-- </h1> -->
                        <p class="mb-4"></p>
                    </div>
                    
                </div>
            </div>
        </div>
        <!-- About End -->

        <!-- About Start -->
    <div class="container-xxl py-5">
            <div class="container">
                <div class="row g-4 align-items-start mb-4">
                <div class="col-lg-12 wow fadeInUp" data-wow-delay="0.3s">
                        <h1 class="display-5 mb-4"> 
                        أهم المجاالت التدريبية فى الشركة
                         </h1> 
                        <p class="mb-4"></p>
                    </div>
                    <div class="col-lg-12 wow fadeInUp" data-wow-delay="0.1s">
                        <img class="img-fluid rounded" src="public/theme/img/magal.png">
                    </div>
                    
                </div>
            </div>
        </div>
        <!-- About End -->

    <!-- Footer Start -->
    <div class="container-fluid bg-dark text-light footer mt-5 py-5 wow fadeIn" data-wow-delay="0.1s">
        <div class="container py-5">
            <div class="row g-5">
                <div class="col-lg-3 col-md-6">
                    <h4 class="text-white mb-4"><?php echo e($language['site_word_branches']); ?></h4>
                    <p class="mb-2"><i class="fa fa-map-marker-alt me-3"></i><?php echo e($language['address']); ?></p>
                    <p class="mb-2"><i class="fa fa-phone-alt me-3"></i>+010 277 78055</p>
                    <p class="mb-2"><i class="fa fa-envelope me-3"></i>info@mec4con.com</p>
                    <div class="d-flex pt-2">
                        <a class="btn btn-square btn-outline-light rounded-circle me-2" href="<?php echo e($site_setting->twitter); ?>"><i class="fab fa-twitter"></i></a>
                        <a class="btn btn-square btn-outline-light rounded-circle me-2" href="<?php echo e($site_setting->facebook); ?>"><i class="fab fa-facebook-f"></i></a>
                        <a class="btn btn-square btn-outline-light rounded-circle me-2" href="<?php echo e($site_setting->youtube); ?>"><i class="fab fa-youtube"></i></a>
                        <a class="btn btn-square btn-outline-light rounded-circle me-2" href="<?php echo e($site_setting->linkedin); ?>"><i class="fab fa-linkedin-in"></i></a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <h4 class="text-white mb-4"><?php echo e($language['site_word_services']); ?></h4>
                    <a class="btn btn-link" href="#"><?php echo e($language['site_word_training']); ?></a>
                    <a class="btn btn-link" href="#"><?php echo e($language['site_word_consultation']); ?></a>
                    <a class="btn btn-link" href="#"><?php echo e($language['site_word_feasibility_studies']); ?></a>
                    <a class="btn btn-link" href="#"><?php echo e($language['site_word_recruitment']); ?></a>
                </div>
                <div class="col-lg-3 col-md-6">
                    <h4 class="text-white mb-4"><?php echo e($language['site_word_hot_links']); ?></h4>
                    <a class="btn btn-link" href="#"><?php echo e($language['site_word_about_us']); ?></a>
                    <a class="btn btn-link" href="#"><?php echo e($language['site_word_contact']); ?></a>
                    <a class="btn btn-link" href="#"><?php echo e($language['site_word_services']); ?></a>
                    <a class="btn btn-link" href="#"><?php echo e($language['site_word_privacy_policy']); ?></a>
                </div>
            
            </div>
        </div>
    </div
    <!-- Footer End -->





    <!-- Back to Top -->
    <a href="#" class="btn btn-lg btn-primary btn-lg-square rounded-circle back-to-top"><i class="bi bi-arrow-up"></i></a>


    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="public/theme/lib/wow/wow.min.js"></script>
    <script src="public/theme/lib/easing/easing.min.js"></script>
    <script src="public/theme/lib/waypoints/waypoints.min.js"></script>
    <script src="public/theme/lib/owlcarousel/owl.carousel.min.js"></script>
    <script src="public/theme/lib/counterup/counterup.min.js"></script>

    <!-- Template Javascript -->
    <script src="public/theme/js/main.js"></script>
</body>

</html><?php /**PATH C:\xampp-8.0\htdocs\mek\resources\views/theme/page.blade.php ENDPATH**/ ?>