<!DOCTYPE html>
<html lang="ar">

<head>
<meta charset="utf-8">
    <title><?php echo e($language['site_title']); ?></title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Favicon -->
    <link href="img/favicon.ico" rel="icon">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Jost:wght@500;600;700&family=Open+Sans:wght@400;500&display=swap" rel="stylesheet">  

    <!-- Icon Font Stylesheet -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link href="public/theme/lib/animate/animate.min.css" rel="stylesheet">
    <link href="public/theme/lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">
 <?php if(session('site_lang') == "ar"): ?>
    <!-- Customized Bootstrap Stylesheet -->
    <link href="public/theme/css/bootstrap_ar.min.css" rel="stylesheet">
    <!-- Template Stylesheet -->
    <link href="public/theme/css/style_ar.css" rel="stylesheet">
<?php else: ?>
    <!-- Customized Bootstrap Stylesheet -->
    <link href="public/theme/css/bootstrap_en.min.css" rel="stylesheet">
    <!-- Template Stylesheet -->
    <link href="public/theme/css/style_en.css" rel="stylesheet">
<?php endif; ?>
</head>

<body>
<?php echo $__env->make('common.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
   <!-- Spinner Start -->
    <div id="spinner" class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
        <div class="spinner-border text-primary" role="status" style="width: 3rem; height: 3rem;"></div>
    </div>
    <!-- Spinner End -->


    <!-- Navbar Start -->
    <div class="container-fluid fixed-top px-0 wow fadeIn" data-wow-delay="0.1s">
        

        <nav class="navbar navbar-expand-lg navbar-light py-lg-0 px-lg-5 wow fadeIn" data-wow-delay="0.1s">
            <a href="home" class="navbar-brand ms-4 ms-lg-0">
                    <img src="public/admin/images/setting/<?php echo e($site_setting->logo); ?>" alt="MEC Logo" class="navbar-brand-img" style="height: 5rem;">
            </a>
            <button type="button" class="navbar-toggler me-4" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarCollapse">
                <div class="navbar-nav ms-auto p-4 p-lg-0">
                    <a href="home" class="nav-item nav-link"><?php echo e($language['site_word_home']); ?></a>
                    <a href="about" class="nav-item nav-link"><?php echo e($language['site_word_about_us']); ?></a>
                    <a href="training" class="nav-item nav-link"><?php echo e($language['site_word_training']); ?></a>
                    <a href="consultation" class="nav-item nav-link"><?php echo e($language['site_word_consultation']); ?></a>
                    <a href="studies" class="nav-item nav-link"><?php echo e($language['site_word_feasibility_studies']); ?></a>
                    <a href="recruitment" class="nav-item nav-link active"><?php echo e($language['site_word_recruitment']); ?></a>
                </div>
                <div class="d-none d-lg-flex ms-2">
                    <a class="btn btn-light btn-sm-square rounded-circle ms-3" href="<?php echo e($site_setting->facebook); ?>">
                        <small class="fab fa-facebook-f text-primary" style="color: #f9b21c !important;"></small>
                    </a>
                    <a class="btn btn-light btn-sm-square rounded-circle ms-3" href="<?php echo e($site_setting->twitter); ?>">
                        <small class="fab fa-twitter text-primary" style="color: #f9b21c !important;"></small>
                    </a>
                    <a class="btn btn-light btn-sm-square rounded-circle ms-3" href="<?php echo e($site_setting->linkedin); ?>">
                        <small class="fab fa-linkedin-in text-primary" style="color: #f9b21c !important;"></small>
                    </a>
                </div>
            </div>
        </nav>
    </div>
    <!-- Navbar End -->


    <!-- Page Header Start -->
    <div class="container-fluid page-header7 mb-5 wow fadeIn" data-wow-delay="0.1s">
        <div class="container">
            <h1 class="display-3 mb-4 animated slideInDown"><?php echo e($language['site_word_recruitment']); ?></h1>
            <nav aria-label="breadcrumb animated slideInDown">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="home"><?php echo e($language['site_word_home']); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e($language['site_word_recruitment']); ?></li>
                </ol>
            </nav>
        </div>
    </div>
    <!-- Page Header End -->


    <!-- About Start -->
    <div class="container-xxl py-5">
        <div class="container">
            <div class="row g-4 h-100 justify-content-center align-items-center mb-4">
               
                <div class="col-lg-8 wow fadeInUp" data-wow-delay="0.3s">
                 
                        <?php echo $language['site_word_recruitment_section_1']; ?>

                    <p class="mb-4"></p>
                </div>
                <div class="col-lg-4  wow fadeInUp" data-wow-delay="0.1s">
                    <img class="img-fluid rounded" src="public/admin/images/setting/<?php echo e($site_setting->recruitment_img1); ?>">
                </div>
            </div>
        </div>
    </div>
    <!-- About End -->
    <!-- About Start -->
    <div class="container-xxl py-5">
            <div class="container">
                <div class="row g-4 align-items-center mb-4">
                    <div class="col-lg-4 wow fadeInUp" data-wow-delay="0.1s">
                        <img class="img-fluid rounded" src="public/admin/images/setting/<?php echo e($site_setting->recruitment_img2); ?>">
                    </div>
                    <div class="col-lg-8 wow fadeInUp" data-wow-delay="0.3s">
                     
                            <?php echo $language['site_word_recruitment_section_2']; ?>

                        <p class="mb-4"></p>
                    </div>
                    
                </div>
            </div>
        </div>
        <!-- About End -->

        <!-- About Start -->
    <div class="container-xxl py-5">
            <div class="container">
                <div class="row g-4 align-items-start mb-4">
                <div class="col-lg-8 wow fadeInUp" data-wow-delay="0.3s">
                <?php echo $language['site_word_recruitment_section_3']; ?>

                       
                    </div>
                    <div class="col-lg-4 wow fadeInUp" data-wow-delay="0.1s">
                        <img class="img-fluid rounded" src="public/admin/images/setting/<?php echo e($site_setting->recruitment_img3); ?>">
                    </div>
                    
                </div>
            </div>
        </div>
        <!-- About End -->

            <!-- Callback Start -->
    <div class="container-fluid callback my-5 pt-5">
        <div class="container pt-5">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="bg-white border rounded p-4 p-sm-5 wow fadeInUp" data-wow-delay="0.5s">
                        <div class="text-center mx-auto wow fadeInUp" data-wow-delay="0.1s" style="max-width: 600px;">
                            <p class="d-inline-block border rounded text-primary fw-semi-bold py-1 px-3"><?php echo e($language['site_word_stay_contact']); ?></p>
                            <h1 class="display-5 mb-5"> <?php echo e($language['site_word_send_call_back']); ?></h1>
                        </div>
                        <form action="contact/send"  method="GET">
                        <div class="row g-3">
                            <?php echo e(csrf_field()); ?>

                            <div class="col-sm-6">
                                <div class="form-floating">
                                    <input type="text" class="form-control" name="name" required="required" placeholder="Your Name">
                                    <label for="name"><?php echo e($language['name']); ?></label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-floating">
                                    <input type="text" class="form-control" name="phone" required="required" placeholder="Your Phone">
                                    <label for="mobile"><?php echo e($language['site_word_phone']); ?> </label>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="form-floating">
                                    <input type="email" class="form-control" name="email" required="required" placeholder="Your Email">
                                    <label for="mail"><?php echo e($language['site_word_email']); ?></label>
                                </div>
                            </div>
                            <!-- <div class="col-sm-6">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="subject" placeholder="Subject">
                                    <label for="subject">العنوان</label>
                                </div>
                            </div> -->
                            <div class="col-12">
                                <div class="form-floating">
                                    <textarea class="form-control" placeholder="Leave a message here" name="message" required="required" style="height: 100px"></textarea>
                                    <label for="message"><?php echo e($language['site_word_message']); ?></label>
                                </div>
                            </div>
                            <div class="col-12 text-center">
                                <button class="btn btn-primary w-100 py-3" type="submit"><?php echo e($language['site_word_send']); ?></button>
                            </div>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Callback End -->

    <!-- ISO Start -->
    <div class="container-xxl py-5">
        <div class="container">
            <div class="text-center mx-auto wow fadeInUp" data-wow-delay="0.1s" style="max-width: 600px;">
                <!-- <p class="d-inline-block border rounded text-primary fw-semi-bold py-1 px-3">العملاء</p> -->
                <h1 class="display-5 mb-5"> <?php echo e($language['site_word_iso_corp']); ?></h1>
            </div>
            <div class="owl-carousel testimonial-carousel wow fadeInUp" data-wow-delay="0.3s">
                <?php $__currentLoopData = $isos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iso): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>    
            <div class="testimonial-item">
                   
                    <img class="" src="public/admin/images/iso/<?php echo e($iso->image); ?>" alt="">
                    <p><?php echo e($iso->title); ?></p>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                
            </div>
        </div>
    </div>
    <!-- ISO End -->
    
     <!-- Reviews Start -->
     <div class="container-xxl py-5">
        <div class="container">
            <div class="text-center mx-auto wow fadeInUp" data-wow-delay="0.1s" style="max-width: 600px;">
                <!-- <p class="d-inline-block border rounded text-primary fw-semi-bold py-1 px-3">Testimonial</p> -->
                <h1 class="display-5 mb-5"> <?php echo e($language['site_word_client_reviews']); ?> </h1>
            </div>
            <div class="owl-carousel client-carousel wow fadeInUp" data-wow-delay="0.3s">
                <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="client-item">
                    <div class="client-text border rounded p-4 pt-5 mb-5">
                        <div class="btn-square bg-white border rounded-circle">
                            <i class="fa fa-quote-right fa-2x text-primary"></i>
                        </div>
                        <?php echo e($review->message); ?>

                         </div>
                    <img class="rounded-circle mb-3" src="public/admin/images/review/<?php echo e($review->image); ?>" alt="">
                    <h4><?php echo e($review->name); ?></h4>
                    <span><?php echo e($review->job); ?></span>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
            </div>
        </div>
    </div>
    <!-- Reviews End -->

    <!-- Footer Start -->
    <div class="container-fluid bg-dark text-light footer mt-5 py-5 wow fadeIn" data-wow-delay="0.1s">
        <div class="container py-5">
            <div class="row g-5">
                <div class="col-lg-3 col-md-6">
                    <h4 class="text-white mb-4"><?php echo e($language['site_word_branches']); ?></h4>
                   <p class="mb-2"><i class="fa fa-map-marker-alt me-3"></i><span dir="ltr"><?php echo e($site_setting->address); ?></span></p>
                    <p class="mb-2"><i class="fa fa-phone-alt me-3"></i><span dir="ltr"><?php echo e($site_setting->landline); ?></span></p>
                    <p class="mb-2"><i class="fa fa-fax me-3"></i><span dir="ltr"><?php echo e($site_setting->fax); ?></span></p>
                    <p class="mb-2"><i class="fa fa-mobile-alt me-3"></i><span dir="ltr"><?php echo e($site_setting->mobile); ?></span></p>
                    <p class="mb-2"><i class="fa fa-envelope me-3"></i><span dir="ltr"><?php echo e($site_setting->email); ?></span></p>
                    <div class="d-flex pt-2">
                        <a class="btn btn-square btn-outline-light rounded-circle me-2" href="<?php echo e($site_setting->twitter); ?>"><i class="fab fa-twitter"></i></a>
                        <a class="btn btn-square btn-outline-light rounded-circle me-2" href="<?php echo e($site_setting->facebook); ?>"><i class="fab fa-facebook-f"></i></a>
                        <a class="btn btn-square btn-outline-light rounded-circle me-2" href="<?php echo e($site_setting->youtube); ?>"><i class="fab fa-youtube"></i></a>
                        <a class="btn btn-square btn-outline-light rounded-circle me-2" href="<?php echo e($site_setting->linkedin); ?>"><i class="fab fa-linkedin-in"></i></a>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <h4 class="text-white mb-4"><?php echo e($language['site_word_services']); ?></h4>
                    <a class="btn btn-link" href="training"><?php echo e($language['site_word_training']); ?></a>
                    <a class="btn btn-link" href="consultation"><?php echo e($language['site_word_consultation']); ?></a>
                    <a class="btn btn-link" href="studies"><?php echo e($language['site_word_feasibility_studies']); ?></a>
                    <a class="btn btn-link" href="recruitment"><?php echo e($language['site_word_recruitment']); ?></a>
                </div>
                <!--<div class="col-lg-3 col-md-6">-->
                <!--    <h4 class="text-white mb-4"><?php echo e($language['site_word_work']); ?></h4>-->
                <!--    <a class="btn btn-link" href="jobs"><?php echo e($language['site_word_jobs']); ?></a>-->
                <!--    <a class="btn btn-link" href="certification"><?php echo e($language['site_word_certificate']); ?></a>-->
                <!--    <a class="btn btn-link" href="mba"><?php echo e($language['site_word_mba']); ?></a>-->
                <!--    <a class="btn btn-link" href="diploma"><?php echo e($language['site_word_diploma']); ?></a>-->
                <!--</div>-->
                <div class="col-lg-3 col-md-6">
                    <h4 class="text-white mb-4"><?php echo e($language['site_word_hot_links']); ?></h4>
                    <a class="btn btn-link" href="about"><?php echo e($language['site_word_about_us']); ?></a>
                    <a class="btn btn-link" href="contact"><?php echo e($language['site_word_contact']); ?></a>
                    <a class="btn btn-link" href="jobs"><?php echo e($language['site_word_jobs']); ?></a>
                    <a class="btn btn-link" href="clients"><?php echo e($language['site_word_clients']); ?></a>
                    <a class="btn btn-link" href="policy"><?php echo e($language['site_word_privacy_policy']); ?></a>
                </div>
            
            </div>
        </div>
    </div
    <!-- Footer End -->





    <!-- Back to Top -->
    <a href="#" class="btn btn-lg btn-primary btn-lg-square rounded-circle back-to-top"><i class="bi bi-arrow-up"></i></a>


    <!-- JavaScript Libraries -->
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="public/theme/lib/wow/wow.min.js"></script>
    <script src="public/theme/lib/easing/easing.min.js"></script>
    <script src="public/theme/lib/waypoints/waypoints.min.js"></script>
    <script src="public/theme/lib/owlcarousel/owl.carousel.min.js"></script>
    <script src="public/theme/lib/counterup/counterup.min.js"></script>

    <!-- Template Javascript -->
    <script src="public/theme/js/main.js"></script>
</body>

</html><?php /**PATH /home/hosakdnx/hosazz.com/mec/resources/views/theme/recruitment.blade.php ENDPATH**/ ?>