<!DOCTYPE html>
<html lang="en">
  <head>
    <title><?php echo e($language['site_title']); ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <link href="https://fonts.googleapis.com/css?family=Poppins:200,300,400,500,600,700,800&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/gh/lipis/flag-icons@6.11.0/css/flag-icons.min.css"/>
    <link rel="stylesheet" href="/public/theme/css/open-iconic-bootstrap.min.css">
    <link rel="stylesheet" href="/public/theme/css/animate.css">
    
    <link rel="stylesheet" href="/public/theme/css/owl.carousel.min.css">
    <link rel="stylesheet" href="/public/theme/css/owl.theme.default.min.css">
    <link rel="stylesheet" href="/public/theme/css/magnific-popup.css">

    <link rel="stylesheet" href="/public/theme/css/aos.css">
 
    <link rel="stylesheet" href="/public/theme/css/ionicons.min.css">

    <!--<link rel="stylesheet" href="public/theme/css/bootstrap-datepicker.css">-->
    <link rel="stylesheet" href="/public/theme/css/jquery.timepicker.css">

    
    <link rel="stylesheet" href="/public/theme/css/flaticon.css">
    <link rel="stylesheet" href="/public/theme/css/icomoon.css">
     <?php if(session('site_lang') == "ar"): ?>
        <link rel="stylesheet" href="/public/theme/css/styleAr.css">
        <link rel="stylesheet" href="/public/theme/css/bootstrap-datepickerAr.css">
    <?php else: ?>
        <link rel="stylesheet" href="/public/theme/css/styleEn.css">
        <link rel="stylesheet" href="/public/theme/css/bootstrap-datepickerEn.css">
    <?php endif; ?>
    
  </head>
  <body>
    
     <style>
      .datepicker.dropdown-menu{ z-index:99999 !important; }

  </style>
                   <?php echo $__env->make('common.notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

	  <nav class="navbar navbar-expand-lg navbar-dark ftco_navbar bg-dark ftco-navbar-light" id="ftco-navbar">
	    <div class="container">
	      <a class="navbar-brand" href="/">
	          
               <img src="/public/theme/images/logo2.png" style="width: 150px;"></img>
               </a>
	      <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#ftco-nav" aria-controls="ftco-nav" aria-expanded="false" aria-label="Toggle navigation">
	        <span class="oi oi-menu"></span> 
	      </button>

	      <div class="collapse navbar-collapse" id="ftco-nav">
	        <ul class="navbar-nav ml-auto">
	          <li class="nav-item "><a href="/" class="nav-link"><?php echo e($language['site_word_home']); ?></a></li>
	          <li class="nav-item"><a href="/about" class="nav-link"><?php echo e($language['site_word_about']); ?></a></li>
	          <li class="nav-item active"><a href="#" class="nav-link"><?php echo e($language['site_word_cars']); ?></a></li>
	          <li class="nav-item"><a href="/contact" class="nav-link"><?php echo e($language['site_word_contact']); ?></a></li>
                <?php if(session('user_id')): ?>
	          <li class="nav-item"><a href="/profile" class="nav-link"><?php echo e($language['site_word_profile']); ?></a></li>
	          <li class="nav-item"><a href="/logout" class="nav-link"><?php echo e($language['site_word_logout']); ?></a></li>
	                <?php else: ?>
	          <li class="nav-item"><a href="/login" class="nav-link"><?php echo e($language['site_word_login']); ?></a></li>	        
	        <?php endif; ?>
	        </ul>
	        <div class="dropdown">
                <a class="dropdown-toggle" href="#" id="Dropdown" role="button" data-mdb-toggle="dropdown" aria-expanded="false">
                    <i></i>
                    <?php if(session('site_lang') == "ar"): ?>
                    <img src="/public/ae.svg" style="width: 25px;" ></img>
                    <?php else: ?>
                    <img src="/public/um.svg" style="width: 25px;" ></img>
                    <?php endif; ?>
                </a>
            
                <ul class="dropdown-menu" aria-labelledby="Dropdown">
                    <li>
                        <a class="dropdown-item" href="/lang/en"><i><img src="/public/um.svg" style="width: 25px" ></img></i> <?php echo e($language['english']); ?> <i class="fa fa-check text-success ms-2"></i></a>
                    </li>
                    <li><hr class="dropdown-divider" /></li>
                    <li>
                        <a class="dropdown-item" href="/lang/ar"><i><img src="/public/ae.svg" style="width: 25px" ></img></i> <?php echo e($language['arabic']); ?></a>
                    </li>
                 
                
                </ul>
            </div>
	        
	      </div>
	    </div>
	  </nav>
    <!-- END nav -->
    
    <section class="hero-wrap hero-wrap-2 js-fullheight" style="background-image: url('/public/theme/images/bg_3.jpg');" data-stellar-background-ratio="0.5">
      <div class="overlay"></div>
      <div class="container">
        <div class="row no-gutters slider-text js-fullheight align-items-end justify-content-start">
          <div class="col-md-9 ftco-animate pb-5">
          	<p class="breadcrumbs"><span class="mr-2"><a href="index.html"><?php echo e($language['site_word_home']); ?> <i class="ion-ios-arrow-forward"></i></a></span> <span><?php echo e($language['site_word_cars']); ?> <i class="ion-ios-arrow-forward"></i></span></p>
            <h1 class="mb-3 bread"><?php echo e($language['site_word_choose_your_car']); ?></h1>
          </div>
        </div>
      </div>
    </section>
		


 <section class="ftco-section ftco-no-pt">
    	<div class="container">
    		<div class="row justify-content-center">
          <div class="col-md-12 heading-section text-center ftco-animate mb-5">
          
          
          </div>
        </div>
        <div class="row">
            
            <?php if(count($list) == 0): ?>
              <h3 class="center" style="color:grey;"><?php echo e($language['site_word_no_cars']); ?></h3>
            <?php endif; ?>
             <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

    				<div class="col-md-4">
    				<div class="car-wrap rounded ftco-animate">
    				    <a href="/car/<?php echo e($car->id); ?>" >
    					<div class="img rounded d-flex align-items-end" style="background-image: url(/public/admin/images/<?php echo e($car->image); ?>);">
    					</div>
    					</a>
    					<div class="text">
    						 <a href="/car/<?php echo e($car->id); ?>" >
    			    			     <?php if(session('site_lang') == "ar"): ?>
	    	    						<h2 class="mb-0"><?php echo e($car->title_ar); ?> </h2>
		                             <?php else: ?>
 	    	    						<h2 class="mb-0"><?php echo e($car->title_en); ?></h2>
		                             <?php endif; ?>
             	    				</a>
    						<div class="d-flex mb-3">
			    						<p class="price ml-auto">
			    						     <?php if($car->offer =="0"): ?>
			    						    <?php echo e($car->price); ?> <span>/<?php echo e($language['day']); ?></span></p>
			    						    <?php else: ?>
			    						     <s style="color:lightGrey;"> <?php echo e($car->price); ?></s> <?php echo e(($car->price  - (($car->price * $car->offer) / 100) )); ?> <span>/<?php echo e($language['day']); ?></span></p>
			    						    <?php endif; ?>
    						</div>
    						<p class="d-flex mb-0 d-block">
    						   <a herf="#" data-toggle="modal" data-target="#BookModal<?php echo e($car->id); ?>"  class="btn btn-secondary py-2 mr-1"><?php echo e($language['site_word_book_now']); ?></a> 
		    						 <?php if(!session('user_id')): ?>
		    						<a href="#" data-toggle="modal" data-target="#WhatsAppModal<?php echo e($car->id); ?>" data-car-id="<?php echo e($car->id); ?>" class="btn btn-success py-2 ml-1"><?php echo e($language['admin_word_whatsapp']); ?></a>
		    						<?php endif; ?>
    						    </p>
    					</div>
    				</div>
    			</div>	
    				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>	
            
            
        	
    		
        </div>
    	</div>
    </section>
	
	 

   <footer class="ftco-footer ftco-bg-dark ftco-section">
      <div id="contact" class="container">
        <div class="row mb-5">
          <div class="col-md">
            <div class="ftco-footer-widget mb-4">
              <h2 class="ftco-heading-2"><a href="#" class="logo">
              
                <img src="/public/theme/images/logow.png" style="width: 150px;"></img>
                  </a>
                  </h2>
              <p><?php echo e($language['about_small']); ?></p>
              <ul class="ftco-footer-social list-unstyled float-md-left float-lft mt-5">
                <li class="ftco-animate"><a target="_blank" href="<?php echo e($site_setting->twitter); ?>"><span class="icon-twitter"></span></a></li>
                <li class="ftco-animate"><a target="_blank" href="<?php echo e($site_setting->facebook); ?>"><span class="icon-facebook"></span></a></li>
                <li class="ftco-animate"><a target="_blank" href="<?php echo e($site_setting->instagram); ?>"><span class="icon-instagram"></span></a></li>
                <li class="ftco-animate"><a target="_blank" href="<?php echo e($site_setting->snapchat); ?>"><span class="icon-snapchat"></span></a></li>
                <li class="ftco-animate"><a target="_blank" href="<?php echo e($site_setting->linkedin); ?>"><span class="icon-linkedin"></span></a></li>

              </ul>
            </div>
          </div>
          <!--<div class="col-md">-->
          <!--  <div class="ftco-footer-widget mb-4 ml-md-5">-->
          <!--    <h2 class="ftco-heading-2"><?php echo e($language['site_word_information']); ?></h2>-->
          <!--    <ul class="list-unstyled">-->
          <!--      <li><a href="#" class="py-2 d-block"><?php echo e($language['site_word_about']); ?></a></li>-->
          <!--      <li><a href="#" class="py-2 d-block">Term and Conditions</a></li>-->
          <!--      <li><a href="#" class="py-2 d-block">Best Price Guarantee</a></li>-->
          <!--      <li><a href="#" class="py-2 d-block">Privacy &amp; Cookies Policy</a></li>-->
          <!--    </ul>-->
          <!--  </div>-->
          <!--</div>-->
          <!--<div class="col-md">-->
          <!--   <div class="ftco-footer-widget mb-4">-->
          <!--    <h2 class="ftco-heading-2">Customer Support</h2>-->
          <!--    <ul class="list-unstyled">-->
          <!--      <li><a href="#" class="py-2 d-block">FAQ</a></li>-->
          <!--      <li><a href="#" class="py-2 d-block">Payment Option</a></li>-->
          <!--      <li><a href="#" class="py-2 d-block">Booking Tips</a></li>-->
          <!--      <li><a href="#" class="py-2 d-block">How it works</a></li>-->
          <!--      <li><a href="#" class="py-2 d-block">Contact Us</a></li>-->
          <!--    </ul>-->
          <!--  </div>-->
          <!--</div>-->
          <div class="col-md">
            <div class="ftco-footer-widget mb-4">
            	<h2 class="ftco-heading-2"><?php echo e($language['site_word_have_question']); ?></h2>
            	<div class="block-23 mb-3">
	              <ul>
	                <li><span class="icon icon-map-marker"></span><span class="text"><?php echo e($language['address']); ?></span></li>
	                <li><a href="tel:<?php echo e($site_setting->phone); ?>"><span class="icon icon-phone"></span><span class="text"><?php echo e($site_setting->phone); ?></span></a></li>
	                <li><a target="_blank" href="https://wa.me/<?php echo e($site_setting->whatsapp); ?>"><span class="icon icon-whatsapp"></span><span class="text"><?php echo e($site_setting->whatsapp); ?></span></a></li>
	                <li><a href="mailto:<?php echo e($site_setting->email); ?>"><span class="icon icon-envelope"></span><span class="text"><?php echo e($site_setting->email); ?></span></a></li>
	              </ul>
	            </div>
            </div>
          </div>
        </div>
        <div class="row">
         
          <div class="col-md-12 text-center">

            <p><!-- Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. -->
  <!--
  Copyright &copy;<script>document.write(new Date().getFullYear());</script> All rights reserved | This template is made with <i class="icon-heart color-danger" aria-hidden="true"></i> by <a href="https://colorlib.com" target="_blank">Colorlib</a>
  
  -->
  <!-- Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. --></p>
          </div>
        </div>
      </div>
    </footer>
    
  

  <!-- loader -->
  <div id="ftco-loader" class="show fullscreen"><svg class="circular" width="48px" height="48px"><circle class="path-bg" cx="24" cy="24" r="22" fill="none" stroke-width="4" stroke="#eeeeee"/><circle class="path" cx="24" cy="24" r="22" fill="none" stroke-width="4" stroke-miterlimit="10" stroke="#F96D00"/></svg></div>


    <script src="/public/theme/js/jquery.min.js"></script>
  <script src="/public/theme/js/jquery-migrate-3.0.1.min.js"></script>
  <script src="/public/theme/js/popper.min.js"></script>
  <script src="/public/theme/js/bootstrap.min.js"></script>
  <script src="/public/theme/js/jquery.easing.1.3.js"></script>
  <script src="/public/theme/js/jquery.waypoints.min.js"></script>
  <script src="/public/theme/js/jquery.stellar.min.js"></script>
  <script src="/public/theme/js/owl.carousel.min.js"></script>
  <script src="/public/theme/js/jquery.magnific-popup.min.js"></script>
  <script src="/public/theme/js/aos.js"></script>
  <script src="/public/theme/js/jquery.animateNumber.min.js"></script>
  <script src="/public/theme/js/bootstrap-datepicker.js"></script>
  <script src="/public/theme/js/jquery.timepicker.min.js"></script>
  <script src="/public/theme/js/scrollax.min.js"></script>
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBVWaKrjvy3MaE7SQ74_uJiULgl1JY0H2s&sensor=false"></script>
  <script src="/public/theme/js/google-map.js"></script>
  <script src="/public/theme/js/main.js"></script>
  
  
  
    <!-- model -->
 
  <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal" id="BookModal<?php echo e($car->id); ?>" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="myModalLabel"><?php echo e($language['site_word_book_request_form']); ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form action="/request/send" class="bg-light p-5 contact-form" method="POST">
              <?php echo e(csrf_field()); ?>

            <input type="hidden" name="car_id" value="<?php echo e($car->id); ?>" >
            <div class="form-group">
              <input type="text" name="name" required="required" style="margin-inline-end: 1rem;" class="form-control" placeholder="<?php echo e($language['name']); ?>">
               </div>
            <div class="form-group">
              <input type="email" name="email" required="required" class="form-control" placeholder="<?php echo e($language['site_word_email']); ?>">
            </div>
            <div class="form-group">
              <input type="phone" name="phone" required="required" style="margin-inline-end: 1rem;" class="form-control" placeholder="<?php echo e($language['site_word_phone']); ?>">
               </div>
            <div class="form-group">
              <input type="number" name="days" min="1" required="required" class="form-control" placeholder="<?php echo e($language['site_word_num_days']); ?>">
            </div>
            <div class="form-group">
              <input type="text" name="from" required="required" id="book_pick_date_model" style="margin-inline-end: 1rem;" class="form-control" placeholder="<?php echo e($language['site_word_pick_up_date']); ?>">
               </div>
            <div class="form-group">
              <input type="text" name="to" required="required" id="book_off_date_model" class="form-control" placeholder="<?php echo e($language['site_word_drop_off_date']); ?>">
            </div>
            <div class="form-group">
              <input type="text" name="fplace" required="required" style="margin-inline-end: 1rem;" class="form-control" placeholder="<?php echo e($language['site_word_pick_up_address']); ?>">
               </div>
            <div class="form-group">
              <input type="text" name="tplace" required="required" class="form-control" placeholder="<?php echo e($language['site_word_drop_off_address']); ?>">
            </div>
         <div class="form-group justify-content-center row "  >
              <input type="submit" name="web" value="<?php echo e($language['site_word_send_book_request']); ?>" class="btn btn-danger py-3 px-5 mr-auto ml-auto">
            </div>

          </form>
          </div>
      
    </div>
  </div>
</div>

<div class="modal" id="WhatsAppModal<?php echo e($car->id); ?>" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="myModalLabel"><?php echo e($language['site_word_book_request_form']); ?></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
 <form action="/request/send" class="bg-light p-5 contact-form" method="POST">
              <?php echo e(csrf_field()); ?>

            <input type="hidden" name="car_id" value="<?php echo e($car->id); ?>" >
            <div class="form-group">
              <input type="text" name="name" required="required" style="margin-inline-end: 1rem;" class="form-control" placeholder="<?php echo e($language['name']); ?>">
               </div>
            <div class="form-group">
              <input type="email" name="email" required="required" class="form-control" placeholder="<?php echo e($language['site_word_email']); ?>">
            </div>
            <div class="form-group">
              <input type="phone" name="phone" required="required" style="margin-inline-end: 1rem;" class="form-control" placeholder="<?php echo e($language['site_word_phone']); ?>">
               </div>
            <div class="form-group">
              <input type="number" name="days" min="1" required="required" class="form-control" placeholder="<?php echo e($language['site_word_num_days']); ?>">
            </div>
            <div class="form-group">
              <input type="text" name="from" required="required" id="book_pick_date_model" style="margin-inline-end: 1rem;" class="form-control" placeholder="<?php echo e($language['site_word_pick_up_date']); ?>">
               </div>
            <div class="form-group">
              <input type="text" name="to" required="required" id="book_off_date_model" class="form-control" placeholder="<?php echo e($language['site_word_drop_off_date']); ?>">
            </div>
            <div class="form-group">
              <input type="text" name="fplace" required="required" style="margin-inline-end: 1rem;" class="form-control" placeholder="<?php echo e($language['site_word_pick_up_address']); ?>">
               </div>
            <div class="form-group">
              <input type="text" name="tplace" required="required" class="form-control" placeholder="<?php echo e($language['site_word_drop_off_address']); ?>">
            </div>
         <div class="form-group justify-content-center row "  >
              <input type="submit"  name="whats" value="<?php echo e($language['site_word_send_throw_whatsapp']); ?>" class="btn btn-success py-3 px-5 mr-auto ml-auto">
            </div>

          </form>
          </div>
     
    </div>
  </div>
</div>
    
    <script>
     $('#BookModal<?php echo e($car->id); ?>').on('shown.bs.modal', function (e) {
     	$('#book_pick_date_model,#book_off_date_model').datepicker({
	  'format': 'yyyy-mm-dd',
       container: "#BookModel",
	  'autoclose': true
	        });
    });
    
     $('#WhatsAppModal<?php echo e($car->id); ?>').on('shown.bs.modal', function (e) {
     	$('#book_pick_date_model,#book_off_date_model').datepicker({
	  'format': 'yyyy-mm-dd',
       container: "#BookModel",
	  'autoclose': true
	        });
    });
    
    </script>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>   
    
  </body>
</html><?php /**PATH /home/afanhttk/public_html/resources/views/theme/cars.blade.php ENDPATH**/ ?>